#ifndef __TRINT_AP__
#define __TRINT_AP__

#ifndef ROOT_TApplication
#include "TApplication.h"
#endif
#ifndef ROOT_TString
#include "TString.h"
#endif
#ifndef AnapawMode
#include "AnapawMode.hh"
#endif
#include "TRint.h"


class TFileHandler;

class TRint_ap : public TRint
{

private:
   Int_t         fNcmd;               // command history number
   TString       fDefaultPrompt;      // default prompt: "root [%d] "
   char          fPrompt[64];         // interpreter prompt
   Bool_t        fInterrupt;          // if true macro execution will be stopped
   TFileHandler *fInputHandler;       // terminal input handler
   AnapawMode    anapaw;

public:
  TRint_ap(const char *appClassName, Int_t *argc, char **argv,
	   void *options=0, int numOptions=0, Bool_t noLogo = kFALSE);
  ~TRint_ap();

  virtual void PrintLogo(Bool_t lite = kFALSE);
  virtual Bool_t HandleTermInput();
  virtual char *GetPrompt();

  ClassDef(TRint_ap,0)
};
#endif

