#!/bin/sh
#
# Shell script for Default command list for aproot from Nadeko/ananadeko_linkdef.h

# modify these directories
# if you need
#TARTSYS=/home/kondo/exp/anaroot/anaroot
TARTSYS=$1
NADEKODIR=$TARTSYS/sources/Nadeko
ANALOOPDIR=$TARTSYS/sources/AnaLoop
#


HEADFILE="src/AnapawMode.cc.head"
OUTFILE="src/AnapawMode.cc"

cp -f $HEADFILE $OUTFILE

MATCH="#pragma link C++ function "

cat $HEADFILE > $OUTFILE
echo "void AnapawMode::SetDefaultComList(){" >> $OUTFILE

#-------------------------------------------------------
# for Nadeko
#

INFILE=$NADEKODIR/ananadeko_linkdef.hh

while read LINE; do
# extract command word from matched line
LINE=`echo $LINE | sed -e "s/$MATCH\(.*\);/\1/"`
# other lines -> empty
LINE=`echo $LINE | sed -e "/^#/d"`
# remove comment lines
LINE=`echo $LINE | sed -e "/^\/\/.*/d"`
# remove empty line and sandwich the command by C++ words
echo $LINE | sed -e '/^$/d' | sed -e 's/^/  AddComList(\"/g' | sed -e 's/$/\");/g' >> $OUTFILE
done < $INFILE

#-------------------------------------------------------
# for AnaLoop
#

INFILE=$ANALOOPDIR/anaanaloop_linkdef.hh

while read LINE; do
# extract command word from matched line
LINE=`echo $LINE | sed -e "s/$MATCH\(.*\);/\1/"`
# other lines -> empty
LINE=`echo $LINE | sed -e "/^#/d"`
# remove comment lines
LINE=`echo $LINE | sed -e "/^\/\/.*/d"`
# remove empty line and sandwich the command by C++ words
echo $LINE | sed -e '/^$/d' | sed -e 's/^/  AddComList(\"/g' | sed -e 's/$/\");/g' >> $OUTFILE
done < $INFILE

echo "}" >> $OUTFILE

#
#
#
