void hstatus(TH1 *h){

  cout<<
    "----------------------------------------------------------------------"
      <<endl;
  cout<<"Name  : "<<h->GetName()<<" (1D-histogram)     "
      <<"Title : "<<h->GetTitle()<<endl<<endl;

  cout<<"   Xaxis : "<<h->GetNbinsX()
      <<" bins    ["<<h->GetXaxis()->GetXmin()
      <<":"<<h->GetXaxis()->GetXmax()
      <<"]  dx="<<h->GetBinWidth(1)
      <<endl;

  cout<<"   Counts / Entries = "<<h->Integral()
      <<" / "<<h->GetEntries()
      <<"  ("<<h->Integral()/h->GetEntries()*100<<" %)"<<endl;

//  cout<<"Entries  : "<<h->GetEntries()<<endl;
//  cout<<"Counts   : "<<h->Integral()
//      <<"  ("<<h->Integral()/h->GetEntries()*100<<" %)"<<endl;
  cout<<"   Mean = "<<h->GetMean()
      <<"   RMS = "<<h->GetRMS()<<endl;
}

void hstatus(TH2 *h){
  cout<<
    "----------------------------------------------------------------------"
      <<endl;
  cout<<"Name     : "<<h->GetName()<<" (2D-histogram)     "
      <<"Title    : "<<h->GetTitle()<<endl;
  cout<<"Entries  : "<<h->GetEntries()<<endl;
  cout<<"Counts   : "<<h->Integral()
      <<"  ("<<h->Integral()/h->GetEntries()*100<<" %)"<<endl;
  cout<<"Xaxis    : "<<h->GetNbinsX()
      <<" bins,  xmin="<<h->GetXaxis()->GetXmin()
      <<"  xmax="<<h->GetXaxis()->GetXmax()
      <<"  dx="<<h->GetBinWidth(1)
      <<endl;

  cout<<"Yaxis    : "<<h->GetNbinsY()
      <<" bins,  ymin="<<h->GetYaxis()->GetXmin()
      <<"  ymax="<<h->GetYaxis()->GetXmax()
      <<"  dy="<<h->GetYaxis()->GetBinWidth(1)
      <<endl;
}
