#ifndef ROOT_TRint
#include "TRint.h"
#endif

#ifndef ROOT_TApplication
#include "TApplication.h"
#endif

#ifndef ROOT_TObject
#include "TObject.h"
#endif

#ifndef ROOT_TString
#include "TString.h"
#endif

#include "AnapawMode.hh"

class TFileHandler;
class TRint_ap : public TRint {

private:
   Int_t         fNcmd;               // command history number
   TString       fDefaultPrompt;      // default prompt: "root [%d] "
   char          fPrompt[64];         // interpreter prompt
   Bool_t        fInterrupt;          // if true macro execution will be stopped
   TFileHandler *fInputHandler;       // terminal input handler

   AnapawMode anapaw;              //use AnapawMode

//   TRint_ap(const TRint_ap&);               // not implemented
//   TRint_ap& operator=(const TRint_ap&);    // not implemented
//
  void    ExecLogon();
//   Long_t  ProcessRemote(const char *line, Int_t *error = 0);
//
public:
  TRint_ap(const char *appClassName, int *argc, char **argv,
	       void *options = 0, int numOptions = 0, Bool_t noLogo = kFALSE);
  virtual             ~TRint_ap();
  virtual char       *GetPrompt();
//   virtual const char *SetPrompt(const char *newPrompt);
//   virtual void        SetEchoMode(Bool_t mode);
//   virtual void        HandleException(Int_t sig);
//  virtual Bool_t      HandleTermInput();
  Bool_t      HandleTermInput();
  void        PrintLogo(Bool_t lite = kFALSE);
//  virtual void        Run(Bool_t retrn = kFALSE);
//   virtual void        Terminate(int status);
//           void        Interrupt() { fInterrupt = kTRUE; }
//   virtual Int_t       TabCompletionHook(char *buf, int *pLoc, ostream& out);
//


   ClassDef(TRint_ap,0);  //ROOT Interactive Application Interface
};

