#!/bin/sh
#
# Shell script for Default command list for aproot from Nadeko/ananadeko_linkdef.h
#
#INFILE="../Nadeko/ananadeko_linkdef.h"
#HEADFILE="src/AnapawMode.cc.head"
#OUTFILE="src/AnapawMode.cc"
INFILE=$1
HEADFILE=$2
OUTFILE=$3

cp -f $HEADFILE $OUTFILE

MATCH="#pragma link C++ function "

cat $HEADFILE > $OUTFILE
echo "void AnapawMode::SetDefaultComList(){" >> $OUTFILE

while read LINE; do
# extract command word from matched line
LINE=`echo $LINE | sed -e "s/$MATCH\(.*\);/\1/"`
# other lines -> empty
LINE=`echo $LINE | sed -e "/^#/d"`
# remove empty line and sandwich the command by C++ words
echo $LINE | sed -e '/^$/d' | sed -e 's/^/  AddComList(\"/g' | sed -e 's/$/\");/g' >> $OUTFILE

done < $INFILE

echo "}" >> $OUTFILE

#
#
#
